title ?= $(shell sed -ne '1s/^% *//p' < $(metahintfile))
author ?= $(shell sed -ne '2s/^% *//p' < $(metahintfile))
creationdate ?= $(shell sed -ne '3s/^% *//p' < $(metahintfile))

mdwnfiles = $(wildcard $(SRCDIR)/*.mdwn)
dotfiles = $(wildcard $(SRCDIR)/*.dot)
gvprfiles = $(wildcard $(SRCDIR)/*.g)

pngdotfiles = $(dotfiles:$(SRCDIR)/%.dot=$(BUILDDIR)/%.png)
gifdotfiles = $(dotfiles:$(SRCDIR)/%.dot=$(BUILDDIR)/%.gif)
jpgdotfiles = $(dotfiles:$(SRCDIR)/%.dot=$(BUILDDIR)/%.jpg)
svgdotfiles = $(dotfiles:$(SRCDIR)/%.dot=$(BUILDDIR)/%.svg)
epsdotfiles = $(dotfiles:$(SRCDIR)/%.dot=$(BUILDDIR)/%.eps)
pdfdotfiles = $(dotfiles:$(SRCDIR)/%.dot=$(BUILDDIR)/%.pdf)
pnggvprfiles = $(gvprfiles:$(SRCDIR)/%.g=$(BUILDDIR)/%.png)
gifgvprfiles = $(gvprfiles:$(SRCDIR)/%.g=$(BUILDDIR)/%.gif)
jpggvprfiles = $(gvprfiles:$(SRCDIR)/%.g=$(BUILDDIR)/%.jpg)
svggvprfiles = $(gvprfiles:$(SRCDIR)/%.g=$(BUILDDIR)/%.svg)
epsgvprfiles = $(gvprfiles:$(SRCDIR)/%.g=$(BUILDDIR)/%.eps)
pdfgvprfiles = $(gvprfiles:$(SRCDIR)/%.g=$(BUILDDIR)/%.pdf)

htmlimgfiles += $(gifgvprfiles) $(gifdotfiles)
pdfimgfiles += $(pdfgvprfiles) $(pdfdotfiles)

infiles = $(wildcard $(SRCDIR)/*.in)
genfiles = $(infiles:$(SRCDIR)/%.in=$(BUILDDIR)/%)

maybecopyfiles = $(htmlcopyfiles) $(pdfcopyfiles) $(javacopyfiles)
streq = $(if $(filter-out xx,x$(subst $1,,$2)$(subst $2,,$1)x),,yes)
copyfiles = $(if $(call streq,$(STATICSRCDIR),$(BUILDDIR)),,$(maybecopyfiles))

installfiles += $(s5) $(htmlreports) $(htmlimgfiles) $(htmlcopyfiles)
installfiles += $(pdfreports)
installfiles += $(javacopyfiles)
installfiles += $(extrafiles)
noinstallfiles = $(filter-out $(extrafiles),$(pdfimgfiles))

$(htmlreports):: $(reportfiles) $(htmlimgfiles) $(htmlcopyfiles)
	pandoc --to=html --smart --standalone --toc --output=$@ $(reportfiles)

$(pdfreports):: $(BUILDDIR)/header.tex $(reportfiles) $(pdfimgfiles) $(pdfcopyfiles)
	for f in $(reportfiles); do cat $$f; echo; done \
	  | sed 's,\([a-z0-9-]*\.\)\(gif\|png\),$(BUILDDIR)\/\1pdf,g;s,\./,,g' \
	  | xmarkdown2pdf --toc -C $(BUILDDIR)/header.tex --output=$@

$(s5):: $(s5file) $(htmlimgfiles) $(htmlcopyfiles)
	pandoc --to=s5 --smart --standalone --output=$@ $(s5file)

$(pngdotfiles):: $(BUILDDIR)/%.png: $(SRCDIR)/%.dot
	dot -Tdot $< | gvpr -c '' | dot -Tpng:cairo -o $@
	optipng -q $@

$(gifdotfiles):: $(BUILDDIR)/%.gif: $(SRCDIR)/%.dot
	dot -Tdot $< | gvpr -c '' | dot -Tgif:cairo -o $@

$(jpgdotfiles):: $(BUILDDIR)/%.jpg: $(SRCDIR)/%.dot
	dot -Tdot $< | gvpr -c '' | dot -Tjpg:cairo -o $@

$(svgdotfiles):: $(BUILDDIR)/%.svg: $(SRCDIR)/%.dot
	dot -Tdot $< | gvpr -c '' | dot -Tsvg:cairo -o $@

$(epsdotfiles):: $(BUILDDIR)/%.eps: $(SRCDIR)/%.dot
	dot -Tdot $< | gvpr -c '' | dot -Teps:lasi -o $@

$(pdfdotfiles):: $(BUILDDIR)/%.pdf: $(SRCDIR)/%.dot
	dot -Tdot $< | gvpr -c '' | dot -Tpdf -o $@
#	dot -Tdot $< | gvpr -c '' | dot -Tpdf -Gsize=3.8,3.8 -o $@

# FIXME: depend on gvprdotfile (not all dotfiles)
gvprdotfile = $(SRCDIR)/$(filter-out -%,$(subst -, -,$*)).dot

$(pnggvprfiles):: $(BUILDDIR)/%.png: $(SRCDIR)/%.g $(dotfiles)
	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Tpng:cairo -o $@
	optipng -q $@

$(gifgvprfiles):: $(BUILDDIR)/%.gif: $(SRCDIR)/%.g $(dotfiles)
	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Tgif:cairo -o $@

$(jpggvprfiles):: $(BUILDDIR)/%.jpg: $(SRCDIR)/%.g $(dotfiles)
	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Tjpg:cairo -o $@

$(svggvprfiles):: $(BUILDDIR)/%.svg: $(SRCDIR)/%.g $(dotfiles)
	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Tsvg:cairo -o $@

$(epsgvprfiles):: $(BUILDDIR)/%.eps: $(SRCDIR)/%.g $(dotfiles)
	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Teps:ps -o $@

$(pdfgvprfiles):: $(BUILDDIR)/%.pdf: $(SRCDIR)/%.g $(dotfiles)
	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Tpdf -o $@
#	dot -Tdot $(gvprdotfile) | gvpr -c -f $< | dot -Tpdf -Gsize=3.8,3.8 -o $@

$(genfiles): $(BUILDDIR)/%: $(STATICSRCDIR)/%.in
	mkdir -p $(dir $@)
	sed -e 's/@title@/$(title)/g;s/@author@/$(author)/g;s/@subject@/$(subject)/g;s/@keywords@/$(keywords)/g;s/@creationdate@/$(creationdate)/g;' < $< > $@

$(copyfiles): $(BUILDDIR)/%: $(STATICSRCDIR)/%
	mkdir -p $(dir $@)
	cp -af $< $@
